/* AMX Mod script. 
* connect cs.makportal.net:27015 MOL | Classic :)
* connect cs.makportal.net:27016 MOL | Aim Map :)
*
* AMX Public Restart Round Vote v1.0 (public_rr_vote)
*
* This file is provided as is (no warranties)
*
* Usage
* -----
*	- open file addons\amx\admin.cfg
*	- add these lines to admin.cfg :
*		amx_voterr_delay 60
* 		amx_voterr_time 10
* 		amx_voterr_ratio 0.60
*	- save the changes to file admin.cfg :)
*
* CVARs
* -----
* 	amx_voterr_delay -> minimum delay in seconds between two voting sessions (default 60 sec)
* 	amx_voterr_time  -> how long voting session goes on (default 10 sec)
* 	amx_voterr_ratio -> ratio for voting success (default 0.60)
*
* You can customize the CVARs for your need of course.
*
* To do:
*	- command 'amx_voterr_enable' which admins can use to enable or disable public voting
*	- maybe more public say commands
* 
*/ 

#include <amxmod>
#include <amxmisc>
 
new bool:cstrike
new votefor = 0
new Float:vote_ratio

public restart_round(time[])
{
	server_cmd("sv_restartround %s",time)
	return PLUGIN_CONTINUE
}

public delay_msg() {
	set_hudmessage(255, 0, 0, -1.0, 0.35, 1, 2.0, 6.0, 0.8, 0.8, 1)
	show_hudmessage(0,"Go Go Go :)")
	return PLUGIN_CONTINUE
}

public check_votes() { 
	new players[32],inum
	get_players(players,inum,"c")
	new Float:voteresult = inum ? (float(votefor) / float(inum)) : 0.0
	if (voteresult<vote_ratio){
		client_print(0,print_chat,"[MOL] Рестарта не будет! (ЗА ^"%d^") (ПРОТИВ ^"%d^") (НУЖНО ^"%.2f^" процентов).",votefor,inum-votefor,vote_ratio)
		return PLUGIN_HANDLED
	}
	set_task(6.0,"restart_round",0,"1",1)
	set_task(12.0,"delay_msg")
	client_print(0,print_chat,"[MOL] Большенство проголосовало за рестарт (ЗА ^"%.2f^") (ПРОТИВ ^"%.2f^").",voteresult,inum-votefor,vote_ratio)
	client_print(0,print_chat,"[MOL] Сейчас произойдёт рестарт!")
	return PLUGIN_HANDLED
} 

public count_votes(id,key){
	new name[32] 
	get_user_name(id,name,31)
	client_print(0,print_chat,"%s проголосовал %s.",name,key ? "ПРОТИВ" : "ЗА")
	if (!key) ++votefor
	return PLUGIN_HANDLED 
} 

public voterr(id,level,cid) { 
	new Float:voting = get_cvar_float("amx_last_voting")
	if (voting > get_gametime()){ 
		client_cmd(id, "spk fvox/fuzz"); client_print(id,print_chat,"[MOL] Голосование уже запущенно...") 
		return PLUGIN_HANDLED 
	} 
	if (voting && voting + get_cvar_float("amx_voterr_delay") > get_gametime()) { 
		client_cmd(id, "spk fvox/fuzz"); client_print(id,print_chat,"[MOL] Голосование некоторое время недоступно!")  
		return PLUGIN_HANDLED 
	} 
	new msg[256]
	new keys = (1<<0)|(1<<1)
	if(cstrike)
		format(msg,255,"\yДелать Рестарт?\r^n^n1.  \wДа\r^n2.  \wНет")
	else
		format(msg,255,"Делать Рестарт?^n^n1.  Да^n2.  Нет")
	new Float:vote_time = get_cvar_float("amx_voterr_time") + 2.0 
	set_cvar_float("amx_last_voting", get_gametime() + vote_time)
	vote_ratio = get_cvar_float("amx_voterr_ratio") 
	show_menu(0,keys,msg,floatround(vote_time)) 
	set_task(vote_time,"check_votes")
	client_cmd(id, "spk fvox/bell"); client_print(id,print_chat,"[MOL] Запущенно голосование за рестарт...")
	votefor = 0
	return PLUGIN_HANDLED 
}

public plugin_init() { 
	register_plugin("Vote Restart ROund","1.0","SeSh") 
	register_menucmd(register_menuid("Делать Рестарт?") ,(1<<0)|(1<<1),"count_votes")
	register_clcmd("say /restart","voterr",0,"- starts a vote to restart round")
	register_cvar("amx_voterr_delay","60")
	register_cvar("amx_voterr_time","10")
	register_cvar("amx_voterr_ratio","0.60")
	register_cvar("amx_last_voting","0")
	set_cvar_float("amx_last_voting",0.0)
	new mod_name[32]
	get_modname(mod_name,31)
	cstrike = equal(mod_name,"cstrike") ? true : false
	return PLUGIN_CONTINUE 
}
